package de.renew.remote.cryptix;

import cryptix.provider.*;
import cryptix.provider.cipher.*;
import cryptix.provider.key.*;
import java.io.*;
import java.net.*;
import java.rmi.*;
import java.rmi.server.*;
import xjava.security.*;


public class DESInputStream extends FilterInputStream
{
	private InputStream in;
	private DES decrypter;

	private byte[] buffer;
	private int bufferSize;
	private int usedBytes;
	private boolean eof;

	public DESInputStream(InputStream in, byte[] key)
		throws Exception
	{
		super(in);
		this.in = in;
		decrypter = (DES) Cipher.getInstance("DES/ECB/NONE", "Cryptix");
		decrypter.initDecrypt(new RawSecretKey("DES", key));
		buffer = new byte[32];
		bufferSize = 0;
		usedBytes = 0;
		eof = false;
	}

	public int read()
		throws IOException
	{
		if (usedBytes >= bufferSize)
		{
			readBuffer(true);
		}

		if (eof)
		{
			return -1;
		}

		return buffer[usedBytes++];
	}

	public int read(byte bytes[], int offset, int length)
		throws IOException
	{
		int totalBytes = 0;

		if (usedBytes >= bufferSize && length > 0)
		{
			readBuffer(true);
		}

		while (usedBytes < bufferSize && length > 0)
		{
			if (eof)
			{
				return totalBytes <= 0 ? -1 : totalBytes;
			}

			int copyBytes = bufferSize - usedBytes;
			if (copyBytes > length)
			{
				copyBytes = length;
			}

			if (bytes != null)
			{
				System.arraycopy(buffer, usedBytes, bytes, offset, copyBytes);
			}
			offset += copyBytes;
			length -= copyBytes;
			usedBytes += copyBytes;
			totalBytes += copyBytes;

			if (length > 0)
			{
				readBuffer(false);
			}
		}

		return totalBytes;
	}

	private void readBuffer(boolean blocking)
		throws IOException
	{
		if (!blocking && in.available() <= 0)
		{
			bufferSize = 0;
			usedBytes = 0;
			return;
		}

		bufferSize = in.read();
		if (bufferSize > 32)
		{
			throw new IOException("Corrupt DES stream: buffer size " + bufferSize + " invalid.");
		}

		if (bufferSize < 0)
		{
			eof = true;
			return;
		}

		byte[] encrypted = new byte[32];
		int totalDataBytes = 0;
		while (totalDataBytes < 32)
		{
			int dataBytes = in.read(encrypted, totalDataBytes, 32 - totalDataBytes);
			if (dataBytes < 0)
			{
				throw new IOException("Corrupt DES stream: Unexpected end.");
			}
			totalDataBytes += dataBytes;
		}

		usedBytes = 0;

		buffer = decrypter.crypt(encrypted);
	}

	public int skip(int length)
		throws IOException
	{
		return read(null, 0, length);
	}
}
