package de.renew.unify;

import java.util.Set;

/**
 * This interface enables its objects to be referred to by a {@link Referer}-object.
 * Therefore, it allows backlinks to be added to the object.
 * To check for reference cycles, the method {@link Referable#occursCheck(Unknown, Set)}
 * can be used.
 */
public interface Referable {
    /**
     * Adds the given {@code Reference} to the backlink set.
     *
     * @param reference the reference to add
     * @param recorder  the state recorder to use
     */
    void addBacklink(Reference reference, StateRecorder recorder);

    /**
     * Checks that the references do not contain any cycles.
     *
     * @param that the object to check for occurrences
     * @param visited a set of visited identities
     * @throws Impossible if an impossible state is encountered
     */
    void occursCheck(Unknown that, Set<IdentityWrapper> visited) throws Impossible;
}