/*
 * Created on Dec 27, 2004
 *
 */
package de.renew.net.loading;

import de.renew.shadow.ShadowNetSystem;


/**
 * Abstract class for implementing classes to find nets.
 *
 * @version Dec 27 2004
 * @author Till Kothe
 */
public abstract class Finder {
    /**
     * Constructs a new Finder.
     */
    public Finder() {}


    /**
     * Looks for a net of a given name in a given file
     *
     * @param name the name of the net
     * @param path the file to look in
     * @return the found {@code ShadowNet} or {@code null} if none was found
     */
    public abstract ShadowNetSystem findNetFile(String name, String path);

    /**
     * Looks for a net of a given name in a given file. The file entry
     * is classpath relative.
     *
     * @param name the name of the net
     * @param path the classpath relative filename to look for the net
     * @return the found {@code ShadowNet} or {@code null} if none was found
     */
    public abstract ShadowNetSystem findNetClasspathRel(String name, String path);


    /**
     * The {@code equals} method is overwritten, so that no two {@code Finder}
     * objects of the same implementation can be inserted into a {@code java.util.Set}.
     * This method returns true if and only if the parameter if of the same type as the
     * {@code Finder} whose {@code equals} method is called.
     *
     * @param o the Object to compare to this {@code Finder}
     */
    @Override
    public boolean equals(Object o) {
        return (o.getClass().getName().equals(this.getClass().getName()));
    }

    /**
     * As recommended the {@code hashCode} is overwritten, because the equals method is.
     * The {@code hashCode} returns the {@code Finder}'s class name's
     * {@code hashCode}.
     * (see {@link java.lang.String#hashCode()})
     */
    @Override
    public int hashCode() {
        return (this.getClass().getName().hashCode());
    }
}