package de.renew.net.event;

/**
 * A producer for transition related events.
 */
public interface TransitionEventProducer {
    /**
     * Adds a TransitionEventListener to a corresponding list of listeners.
     *
     * @param listener the TransitionEventListener that is added to the list
     */
    public void addTransitionEventListener(TransitionEventListener listener);

    /**
     * Removes a TransitionEventListener from a corresponding list of listeners.
     *
     * @param listener the TransitionEventListener that is removed from the list
     */
    public void removeTransitionEventListener(TransitionEventListener listener);
}