package de.renew.net.event;

/**
 * An EventListener for Transition-related events.
 */
public interface TransitionEventListener extends NetEventListener {

    /**
     * This event occurs when a TransitionInstance starts a new
     * Occurrence. When the event is sent, it is guaranteed
     * that the firing can take place, meaning that all input tokens have
     * already been successfully collected.
     * <p>
     * The Event is sent to all TransitionInstances which are part of the
     * Occurrence, not only to the triggering TransitionInstance.
     *
     * @param fe the FiringEvent that triggered the changes
     */
    public void firingStarted(FiringEvent fe);

    /**
     * This event signals that a Transition Occurrence has completed.
     * The Event is sent to all TransitionInstances which are part of the
     * Occurrence, not only to the triggering TransitionInstance.
     * <p>
     * The event that is delivered is exactly the same event that was
     * delivered during the start of the firing.
     *
     * @param fe the FiringEvent that triggered the changes
     */
    public void firingComplete(FiringEvent fe);
}