package de.renew.net;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.expression.VariableMapper;


/**
 * A {@code ConstantTokenSource} is a {@link TokenSource} for tokens that are a constant value.
 */
public class ConstantTokenSource implements TokenSource {
    /**
     * The constant that represents the token. This constant will be returned whenever {@link #createToken} is called.
     */
    private Object constant;

    /**
     * Constructs a new {@code ConstantTokenSource} using the given {@code Object} as the constant value.
     *
     * @param constant the token that the {@code ConstantTokenSource} will create
     */
    public ConstantTokenSource(Object constant) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        this.constant = constant;
    }

    @Override
    public Object createToken(VariableMapper mapper) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        return constant;
    }
}