package de.renew.engine.searchqueue;

import java.util.Enumeration;
import java.util.NoSuchElementException;

import de.renew.engine.searcher.Searchable;


class DSQEnumeration implements Enumeration<Searchable> {
    private DSQListNode current;
    private final DSQListNode start;

    DSQEnumeration(DSQListNode start) {
        current = start;
        this.start = start;
    }

    @Override
    public boolean hasMoreElements() {
        return current != null;
    }

    @Override
    public synchronized Searchable nextElement() throws NoSuchElementException {
        if (current == null) {
            throw new NoSuchElementException();
        }
        Searchable result = current.elem;
        current = current.next;
        if (current == start) {
            current = null;
        }
        return result;
    }
}