/*
 * Created on Nov 22, 2004
 *
 */
package de.renew.engine.events;

import java.io.PrintWriter;
import java.io.StringWriter;

import de.renew.net.Net;


/**
 * @author Sven Offermann
 *
 */
public class NetInstantiationException extends ExceptionEvent {

    private final Net net;

    public NetInstantiationException(Net net, Throwable exception) {
        super(exception);

        this.net = net;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);

        out.println("An exception occurred during the instantiation of net " + net.getName());
        getException().printStackTrace(out);

        return writer.toString();
    }
}