package de.renew.engine.common;

import java.util.Collection;

import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.TransitionInstance;
import de.renew.util.IntegerRangeSet;


public class RangeEnumeratorOccurrence extends EnumeratorOccurrence {
    private final int first;
    private final int last;

    public RangeEnumeratorOccurrence(
        Expression expression, boolean checkBound, VariableMapper mapper, int first, int last,
        TransitionInstance tInstance)
    {
        super(expression, checkBound, mapper, tInstance);
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        this.first = first;
        this.last = last;
    }

    @Override
    public Collection<?> getCandidates(Object pattern) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        return new IntegerRangeSet(first, last);
    }
}