package de.renew.database.entitylayer;

import java.sql.SQLException;


/**
 * This class extends SQLException and is an exception for a non-unique primary key in the database.
 */
public class PrimaryKeyNotUniqueException extends SQLException {
    /**
     * This is the default constructor for the PrimaryKeyNotUniqueException, which calls the SQLException's constructor.
     */
    public PrimaryKeyNotUniqueException() {
        super();
    }

    /**
     * Constructor with a String parameter,
     * which calls the SQLException's constructor with the String parameter as parameter.
     * @param message the message, which is displayed alongside the exception
     */
    public PrimaryKeyNotUniqueException(String message) {
        super(message);
    }
}