package de.renew.plugindevelopment.commands;

import CH.ifa.draw.util.Command;
import de.renew.plugindevelopment.generating.PluginGenerator;


/**
 * The generator for a UC (Use Case) diagram is called by a command represented by the
 * CreateApplicationStructureCommand class. It extends the CH.ifa.draw.util.Command class and
 * is intended to be used in conjunction with a plugin development environment.
 *
 * Using a given PluginGenerator instance, this command initiates the creation of an application structure.
 *
 * @author cabac
 */
public class CreateApplicationStructureCommand extends Command {
    private PluginGenerator _generator;

    /**
     * Constructs a CreateApplicationStructureCommand with the given name and PluginGenerator.
     *
     * @param name The name of the constructed command.
     * @param generator The PluginGenerator instance to be the generator of the constructed command.
     */
    public CreateApplicationStructureCommand(String name, PluginGenerator generator) {
        super(name);
        this._generator = generator;
    }

    /*
     * (non-Javadoc)
     *
     * @link CH.ifa.draw.util.Command#execute()
     */
    @Override
    public void execute() {
        this._generator.generate();
    }

    /* (non-Javadoc)
     *
     * @link CH.ifa.draw.util.Command#isExecutable()
     */
    @Override
    public boolean isExecutable() {
        return super.isExecutable();
    }
}