package de.renew.navigator.models;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;


/**
 * @author Elden Sokoli
 */
class ModelTest extends Model {

    private Model _model;

    public ModelTest() {
        super();
    }

    @BeforeEach
    void setUp() {
        _model = new ModelTest();
    }

    @Test
    void testContains() {
        //given
        TreeElement firstTreeElement = mock(TreeElement.class);
        TreeElement secondTreeElement = mock(TreeElement.class);
        assertFalse(_model.contains(firstTreeElement));
        assertFalse(_model.contains(secondTreeElement));

        //when
        _model.add(firstTreeElement);

        //then
        assertTrue(_model.contains(firstTreeElement));
        assertFalse(_model.contains(secondTreeElement));

        //when
        _model.add(secondTreeElement);

        //then
        assertTrue(_model.contains(firstTreeElement));
        assertTrue(_model.contains(secondTreeElement));

        //when
        _model.remove(firstTreeElement);

        //then
        assertFalse(_model.contains(firstTreeElement));
        assertTrue(_model.contains(secondTreeElement));

        //when
        _model.add(secondTreeElement);
        _model.remove(secondTreeElement);

        //then
        assertTrue(_model.contains(secondTreeElement));

    }

    @Test
    void testAdd() {

        //given
        TreeElement treeElement = mock(TreeElement.class);
        assertFalse(_model.contains(treeElement));

        //when
        _model.add(treeElement);

        //then
        assertTrue(_model.contains(treeElement));
        verify(treeElement).setParent(_model);
    }

    @Test
    void testRemove() {

        //given
        TreeElement treeElement = mock(TreeElement.class);
        assertFalse(_model.contains(treeElement));
        _model.add(treeElement);

        //when
        _model.remove(treeElement);

        //then
        assertFalse(_model.contains(treeElement));
        verify(treeElement).setParent(null);
    }
}