package de.renew.navigator.gui;

import java.awt.event.MouseEvent;
import javax.swing.JPanel;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import static org.mockito.ArgumentMatchers.anyInt;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoInteractions;

@ExtendWith(MockitoExtension.class)
class TreeMouseListenerTest {

    @Mock
    private NavigatorGuiImpl gui;
    private TreeMouseListener listener;
    private JPanel dummySource;

    @BeforeEach
    void setUp() {
        listener = new TreeMouseListener(gui);
        // just a non-null Component to serve as MouseEvent source
        dummySource = new JPanel();
    }

    @Test
    void singleLeftClick_DoesNothing() {
        MouseEvent e = new MouseEvent(
            dummySource, MouseEvent.MOUSE_CLICKED, System.currentTimeMillis(), 0, 10, 20, 1, // clickCount = 1
            false, MouseEvent.BUTTON1);
        listener.mouseClicked(e);
        verifyNoInteractions(gui);
    }

    @Test
    void doubleLeftClickCallsOpenSelectedTest() {
        MouseEvent e = new MouseEvent(
            dummySource, MouseEvent.MOUSE_CLICKED, System.currentTimeMillis(), 0, 5, 15, 2, // clickCount > 1
            false, MouseEvent.BUTTON1);
        listener.mouseClicked(e);
        verify(gui, times(1)).openSelected();
        verify(gui, never()).showContextMenu(anyInt(), anyInt());
    }

    @Test
    void tripleLeftClickAlsoCallsOpenSelectedTest() {
        MouseEvent e = new MouseEvent(
            dummySource, MouseEvent.MOUSE_CLICKED, System.currentTimeMillis(), 0, 7, 14, 3, // clickCount > 1
            false, MouseEvent.BUTTON1);
        listener.mouseClicked(e);
        verify(gui).openSelected();
        verify(gui, never()).showContextMenu(anyInt(), anyInt());
    }

    @Test
    void middleClickCallsShowContextMenuTest() {
        int x = 12, y = 34;
        MouseEvent e = new MouseEvent(
            dummySource, MouseEvent.MOUSE_CLICKED, System.currentTimeMillis(), 0, x, y, 1, false,
            MouseEvent.BUTTON2);
        listener.mouseClicked(e);
        verify(gui, never()).openSelected();
        verify(gui, times(1)).showContextMenu(x, y);
    }

    @Test
    void rightClickCallsShowContextMenuTest() {
        int x = 99, y = 100;
        MouseEvent e = new MouseEvent(
            dummySource, MouseEvent.MOUSE_CLICKED, System.currentTimeMillis(), 0, x, y, 1, false,
            MouseEvent.BUTTON3);
        listener.mouseClicked(e);
        verify(gui, never()).openSelected();
        verify(gui, times(1)).showContextMenu(x, y);
    }
}
