package de.renew.watch;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searcher;
import de.renew.unify.Copier;
import de.renew.unify.Variable;


public class ParamFinder implements Finder {
    private Variable _early;
    private Set<Object> _values = new HashSet<Object>();

    public ParamFinder(Variable early) {
        this._early = early;
    }

    // Ok, let's record the settings of the
    // parameters which led to a successful binding.
    @Override
    public void found(Searcher searcher) {
        // Copy the final form of the parameters
        // and insert them into the set.
        // The variable is supposed to be evaluated early,
        // so that it should be fully bound.
        _values.add(new Copier().copy(_early.getValue()));
    }

    // These finders cannot be interrupted.
    @Override
    public boolean isCompleted() {
        return false;
    }

    public Iterator<Object> iterator() {
        return _values.iterator();
    }
}