package de.renew.lola2.gui;

import java.awt.Color;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Figure;
import de.renew.lola2.analysis.LolaResultStatus;


public class LolaGUIHelper {

    /**
     * Changes the fillColor of a Figure to a certain Color.
     *
     * @param fig
     *            - The Figure to be colored
     * @param color
     *            - The color to be used
     */
    public static void colorFigure(Figure fig, Color color) {
        fig.setAttribute("FillColor", color);
        fig.changed();
        DrawPlugin.getGui().view().checkDamage();
    }

    public static Color getStatusColor(LolaResultStatus status) {
        Color result;
        switch (status) {
            case YES:
                result = new Color(0, 153, 0); // dark green
                break;
            case NO:
                result = Color.RED;
                break;
            case ERROR:
                result = Color.BLACK;
                break;
            case UNCHECKED:
                result = Color.GRAY;
                break;
            case INFEASIBLE:
                result = Color.GRAY;
                break;
            default:
                result = Color.GRAY;
        }
        return result;
    }
}