/**
 *
 */

package de.renew.lola2.gui;

import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.commands.CheckAllCommand;


/**
 * @author hewelt, mosteller
 * @date 16.08.2012
 */
public class LolaGUI extends JFrame {
    private static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(CheckAllCommand.class);
    /**
     * The path to the Lola executable or configuration.
     * This is used to run Lola commands from the GUI.
     */
    String _lolaPath = "";


    /**
     * The panels used for the tabs
     */
    private TasksPanel _generalPanel;
    /**
     * The panel that contains the checklist
     */
    private ChecklistPanel _checkListPanel;
    /**
     * The panel that allows editing of markings
     */
    private MarkingEditorPanel _markEdPanel;

    /**
     * The drawing being analyzed at the moment
     */
    CPNDrawing _drawing;


    /**
     * Default constructor for LolaGUI.
     * @throws HeadlessException if GraphicsEnvironment.isHeadless() returns true
     */
    public LolaGUI() throws HeadlessException {
        init();
    }

    /**
     * Creates a LolaGUI with the specified GraphicsConfiguration.
     * @param gc the GraphicsConfiguration that describes the target screen device
     */
    public LolaGUI(GraphicsConfiguration gc) {
        super(gc);
        init();
    }

    /**
     * Creates a LolaGUI with the specified title.
     * @param title title the title to be displayed in the frame's title bar
     * @throws HeadlessException if GraphicsEnvironment.isHeadless() returns true
     */
    public LolaGUI(String title) throws HeadlessException {
        super(title);
        init();
    }

    /**
     * Creates a LolaGUI with the specified title and GraphicsConfiguration.
     * @param title the title to be displayed in the frame's title bar
     * @param gc the GraphicsConfiguration that describes the target screen device
     */
    public LolaGUI(String title, GraphicsConfiguration gc) {
        super(title, gc);
        init();
    }

    /**
     * Creates a LolaGUI with the specified title and Lola path.
     * @param title title the title to be displayed in the frame's title bar
     * @param path the path to the Lola executable or configuration
     */
    public LolaGUI(String title, String path) {
        super(title);
        _lolaPath = path;
        init();
    }

    /**
     * Init the 3 tabs by running their individual setup methods.
     */
    public void init() {
        DrawApplication app = DrawPlugin.getGui();

        // current drawing needs to be a CPNDrawing
        if (app.drawing() instanceof CPNDrawing) {
            _drawing = (CPNDrawing) app.drawing();
            JTabbedPane tabs = new JTabbedPane();
            _generalPanel = new TasksPanel(this);
            _checkListPanel = new ChecklistPanel(this);
            _markEdPanel = new MarkingEditorPanel(this);
            //tabs.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
            tabs.addTab("Checklist", _checkListPanel);
            tabs.addTab("Marking Editor", _markEdPanel);
            tabs.addTab("Tasks", _generalPanel);
            this.add(tabs, BorderLayout.CENTER);
            // now check
            checkNow();
        } else {
            LOGGER.error("[Lola GUI] Could not initialize, no open CPNDrawing.");
        }
    }

    /**
     * This runs the checks in the Checklist and
     * fills the table of the marking editor.
     */
    public void checkNow() {
        _checkListPanel.updateChecklist();
        _markEdPanel.updatePlaces();
    }
}
