/**
 *
 */

package de.renew.lola2.commands;

import java.io.PrintStream;
import java.util.Vector;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.LolaTask;
import de.renew.lola2.analysis.LolaAnalyzer;
import de.renew.plugin.command.CLCommand;


/**
 * Checks a selected verification request with Lola and colors the
 * TextFigure of the request depending on the result.
 *
 * @author hewelt
 *
 */
public class CheckVerificationRequestCommand extends Command implements CLCommand {
    private String _lolaPath;

    private static org.apache.log4j.Logger _logger =
        org.apache.log4j.Logger.getLogger(CheckVerificationRequestCommand.class);

    /**
     * @param name the command name
     * @param path path the lola path
     */
    public CheckVerificationRequestCommand(String name, String path) {
        super(name);
        this._lolaPath = path;
    }

    /**
     * Checks selected verification requests.
     *
     */
    @Override
    public void execute() {
        DrawApplication app = DrawPlugin.getGui();
        Drawing drawing = app.drawing();

        app.getUndoRedoManager().prepareUndoSnapshot(drawing);

        if (!(drawing instanceof CPNDrawing)) {
            _logger.error("[Lola] Drawing needs to be a CPNDrawing. Aborting.");
            return;
        }

        Vector<Figure> selection = app.view().selection();

        // create lola file
        Boolean changed = false;
        for (Figure fig : selection) {
            if (fig instanceof TextFigure) {
                TextFigure textFig = (TextFigure) fig;
                String text = textFig.getText();
                if (text.toLowerCase().startsWith("formula")) {
                    LolaTask task = new LolaTask((TextFigure) fig, (CPNDrawing) drawing);
                    task.check(new LolaAnalyzer(_lolaPath));
                    task.colorFigure();
                    fig.changed();
                    changed = true;
                }
            } else { // if we are not a TextFigure
                _logger.info("[Lola] Currently only checking TextFigures.");
            }
        }
        if (changed) {
            DrawPlugin.getGui().view().checkDamage();
            app.getUndoRedoManager().commitUndoSnapshot(drawing);
        }
    }

    /* (non-Javadoc)
    * @see de.renew.plugin.command.CLCommand#execute(java.lang.String[], java.io.PrintStream)
    */
    @Override
    public void execute(String[] args, PrintStream response) {
        // TODO Auto-generated method stub
    }

    /* (non-Javadoc)
     * @see de.renew.plugin.command.CLCommand#getDescription()
     */
    @Override
    public String getDescription() {
        // TODO Auto-generated method stub
        return null;
    }
}
