package de.renew.logging.gui.test;

import org.apache.log4j.Logger;
import org.junit.jupiter.api.Test;

import de.renew.logging.gui.TreeNodeLoggerWrapper;

import static de.renew.engine.common.SimulatorEventLogger.SIM_LOG_PREFIX;
import static org.junit.jupiter.api.Assertions.assertEquals;

public class TreeNodeLoggerWrapperTest {

    @Test
    public void testGetLogger() {
        final Logger logger = Logger.getLogger(TreeNodeLoggerWrapperTest.class);
        final TreeNodeLoggerWrapper treeNodeLoggerWrapper = new TreeNodeLoggerWrapper(logger);
        assertEquals(logger, treeNodeLoggerWrapper.getLogger());
    }

    @Test
    public void testToString() {
        final Logger simulationRoot = Logger.getLogger(SIM_LOG_PREFIX);
        final Logger simulationOther = Logger.getLogger(SIM_LOG_PREFIX + ".other");

        final TreeNodeLoggerWrapper root = new TreeNodeLoggerWrapper(simulationRoot);
        final TreeNodeLoggerWrapper other = new TreeNodeLoggerWrapper(simulationOther);

        assertEquals("Simulation Root Logger", root.toString());
        assertEquals("other", other.toString());
        assertEquals("simulation", SIM_LOG_PREFIX);
    }
}
