package de.renew.logging.gui;

import org.apache.log4j.Logger;

import de.renew.engine.common.SimulatorEventLogger;


/**
 * Wraps a {@link Logger} as a TreeNode
 *
 * @author Sven Offermann
 */
public class TreeNodeLoggerWrapper {
    private Logger _logger;

    /**
     * Creates new TreeNodeLoggerWrapper
     * @param logger the logger to be wrapped
     */
    public TreeNodeLoggerWrapper(Logger logger) {
        this._logger = logger;
    }

    /**
     * Getter for the logger
     * @return the logger
     */
    public Logger getLogger() {
        return this._logger;
    }

    @Override
    public String toString() {
        String loggerName = _logger.getName();
        if (loggerName.equals(SimulatorEventLogger.SIM_LOG_PREFIX)) {
            loggerName = "Simulation Root Logger";
        } else if (loggerName.startsWith(SimulatorEventLogger.SIM_LOG_PREFIX + ".")) {
            loggerName = loggerName.substring(loggerName.indexOf(".") + 1);
        }

        return loggerName;
    }
}