package de.renew.logging.gui;

/**
 * Used internally to communicate a request to remove the step trace from the repository.
 */
public class StepTraceRemoveRequest {
    private StepTrace _stepTrace;
    private StepTraceRepository _repository;
    private boolean _veto = false;

    /**
     * Creates new StepTraceRemoveRequest
     * @param repository the Repository the StepTrace shall be removed from
     * @param stepTrace the StepTrace that shall be removed
     */
    public StepTraceRemoveRequest(StepTraceRepository repository, StepTrace stepTrace) {
        this._stepTrace = stepTrace;
        this._repository = repository;
    }

    /**
     * Getter for the StepTrace
     * @return the StepTrace
     */
    public StepTrace getStepTrace() {
        return this._stepTrace;
    }

    /**
     * Getter for the repository
     * @return the repository
     */
    public StepTraceRepository getRepository() {
        return this._repository;
    }

    /**
     * Enables the veto for this RemoveRequest
     */
    public void veto() {
        this._veto = true;
    }

    /**
     * Checks if this RemoveRequest has veto
     * @return true if is has veto, false if not
     */
    public boolean hasVeto() {
        return this._veto;
    }
}