package de.renew.plugin.command;

import java.net.URL;
import java.util.ArrayList;

import org.junit.jupiter.api.Test;

import de.renew.plugin.PluginManager;

import static de.renew.plugin.LoadHelper.getJar;
import static de.renew.plugin.LoadHelper.isPluginLoaded;
import static de.renew.plugin.command.CommandHelper.doExecuteSuccessfully;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class GetPropertyCommandTest {

    @Test
    public void testGetPropertyNames() {
        loadPlugin();
        final ArrayList<String> propertyNames = GetPropertyCommand.getPropertyNames();
        assertFalse(propertyNames.isEmpty());
        assertTrue(propertyNames.contains("myProperty"));
    }

    @Test
    public void testGetDescription() {
        final GetPropertyCommand getPropertyCommand = new GetPropertyCommand();
        final String description = getPropertyCommand.getDescription();
        assertEquals(
            "Returns the value of the given PluginProperty. "
                + "Options: [-a| -A] for a listing of all known property names / properties.",
            description);
    }

    @Test
    public void testGetArguments() {
        final GetPropertyCommand getPropertyCommand = new GetPropertyCommand();
        final String arguments = getPropertyCommand.getArguments();
        assertEquals("propertyNames", arguments);
    }

    @Test
    public void testExecute() {
        loadPlugin();

        final String s = doExecuteSuccessfully(new GetPropertyCommand(), "-a");
        assertNotNull(s);
        assertTrue(s.contains("myProperty"));

        final String s2 = doExecuteSuccessfully(new GetPropertyCommand(), "-A");
        assertNotNull(s2);
        assertTrue(
            s2.contains(
                "myProperty = myPropertyValue (known property in plugin TestPlugin GetPropertycommand)"));
        assertTrue(
            s2.contains(
                "name = TestPlugin GetPropertycommand (local value in plugin TestPlugin GetPropertycommand)"));

    }

    private void loadPlugin() {
        if (isPluginLoaded("TestPlugin GetPropertycommand")) {
            return;
        }
        final URL jar = getJar(this.getClass(), "GetPropertyCommand-main.jar");
        PluginManager.getInstance().loadPlugin(jar);
        assertTrue(isPluginLoaded("TestPlugin GetPropertycommand"));
    }


}
