package de.renew.plugin.jpms.impl;

import java.util.List;

import de.renew.plugin.jpms.AbstractLayerFactory;
import de.renew.plugin.jpms.ComponentLayer;


/**
 * A  {@code ComponentLayerFactory}  for {@code PluginLayer}s  only  containing
 * their domain modules. Third-party dependencies must be loaded beforehand.
 *
 * @author Kjell Ehlers
 * @since Renew 4.2
 */
public class PluginLayerFactory extends AbstractLayerFactory {

    @Override
    public ComponentLayer createComponentLayer(
        String name, ModuleLayer.Controller control, List<ComponentLayer> parents)
    {
        return new PluginLayer(name, control, parents);
    }
}
