package de.renew.plugin.di;


/**
 * Collection object for Services to be called
 * @author Konstantin Simon Maria Moellers
 * @version 2015-10-11
 * @param <T> Service to be used for SingletonDefinition
 */
final public class SingletonDefinition<T> extends AbstractDefinition<T> {
    private final T _value;

    /**
     * Constructor for definition
     * @param service Service to be added to definition
     * @param value Callable object to be set as service
     */
    public SingletonDefinition(Class<?> service, T value) {
        super(service);
        this._value = value;
    }

    @Override
    public T create() {
        return _value;
    }
}