package de.renew.plugin;

import de.renew.plugin.command.CLCommand;


/**
 * An observable that provides information about the adding and
 * removing of <code>ClCommand</code>s.
 *
 * @author cabac
 *
 */
public interface CommandsProvider {
    /**
     * Adds a CommandsListener to the CommandsProvider
     * @param listener The CommandsListener to be added
     */
    public void addCommandListener(CommandsListener listener);

    /**
     * Removes a CommandsListener to the CommandsProvider
     * @param listener The CommandsListener to be removed
     */
    public void removeCommandListener(CommandsListener listener);

    /**
     * Notifies CommandsListeners about added Commands
     * @param name Name of the added Command
     * @param command The Command that was added
     */
    public void notifyCommandAdded(String name, CLCommand command);

    /**
     * Notifies CommandsListeners about removal of Commands
     * @param name Name of the removed Command
     */
    public void notifyCommandRemoved(String name);
}