package de.renew.imagenetdiff;

import java.net.URL;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;
import CH.ifa.draw.util.CommandMenu;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;


/**
 * This is a generated file. Generated by PluginDevelopment
 * plugin (version ${pd.version})
 * Representative for the ImageNetDiff plug-in.
 *
 * @author PluginGenerator
 */
public class ImageNetDiffPlugin extends PluginAdapter {
    //private static final String PNG_DIFF_COMMAND = "de.renew.extras.png-diff";
    private CommandMenu _menu;
    private int _blockCounter;

    /**
     * Constructor to generate a new instance of ImageNetDiffPlugin with a given URL.
     * @param url the URL of the plug-in
     * @throws PluginException  if the plug-in cannot be created
     */
    public ImageNetDiffPlugin(URL url) throws PluginException {
        super(url);
        //    registerClasses();
    }

    /**
     * Constructor to generate a new instance of ImageNetDiffPlugin with a given PluginProperties.
     * @param props the PluginProperties of the plug-in
     */
    public ImageNetDiffPlugin(PluginProperties props) {
        super(props);
        //    registerClasses();
    }

    @Override
    public void init() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return;
        }
        PluginManager manager = PluginManager.getInstance();
        manager.addCLCommand("diff", new ImageNetDiffClCommand());
        manager.addCLCommand("epsdiff", new EPSDiffClCommand());

        MenuManager mm = current.getMenuManager();
        _menu = new CommandMenu("Net Diff");
        _menu.putClientProperty(MenuManager.ID_PROPERTY, "de.renew.imagenetdiff");
        _menu.add(new PNGDiffCommand());
        _menu.add(new EPSDiffCommand());
        _menu.add(new VersionInfoCommand(this));
        mm.registerMenu(DrawPlugin.TOOLS_MENU, _menu);
    }

    @Override
    public boolean cleanup() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return true;
        }

        MenuManager mm = current.getMenuManager();

        if (mm != null && _menu != null) {
            mm.unregisterMenu(_menu);
        }
        PluginManager manager = PluginManager.getInstance();
        manager.removeCLCommand("diff");
        manager.removeCLCommand("epsdiff");

        return true;
    }

    @Override
    public synchronized boolean canShutDown() {
        return true;
    }

    /**
     * Adds a block to the plug-in.
     */
    public void addBlock() {
        if (_blockCounter++ == 0) {
            PluginManager manager = PluginManager.getInstance();
            manager.blockExit(this);
        }
    }

    /**
     * Removes a block from the plug-in.
     */
    public void removeBlock() {
        if (--_blockCounter <= 0) {
            PluginManager manager = PluginManager.getInstance();
            manager.exitOk(this);
            _blockCounter = 0;
        }
    }
}