package de.renew.gui.tool;

import java.awt.Point;
import java.awt.event.MouseEvent;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.StandardDrawingView;

/**
 * Lets the user Zoom in with mouse clicks.
 */
public class ZoomInTool extends AbstractZoomTool {

    public ZoomInTool(DrawingEditor editor) {
        super(editor);
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        StandardDrawingView standardDrawingView = getCurrentStandardDrawingView();
        if (standardDrawingView != null) {
            standardDrawingView.zoomInOnPoint(new Point(x, y));
        }
    }
}