/*
 * @(#)VirtualPlaceFigureCreationTool.java 5.1
 *
 */
package de.renew.gui.tool;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CreationTool;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.VirtualPlaceFigure;


/**
 * A more efficient version of the generic Trans creation
 * tool that is not based on cloning.
 */
public class VirtualPlaceFigureCreationTool extends CreationTool {

    /**
     * the currently created figure
     */
    private VirtualPlaceFigure virtualPlace = null;

    public VirtualPlaceFigureCreationTool(DrawingEditor editor) {
        super(editor);
    }

    /**
     * Creates a new VirtualPlaceFigure.
     */
    @Override
    protected Figure createFigure() {
        return new VirtualPlaceFigure(null);
    }

    /**
     * Handles mouse move events in the drawing view.
     */
    @Override
    public void mouseMove(MouseEvent e, int x, int y) {
        // highlight PlaceFigures?
    }

    /**
     * If the mouse down hits a PlaceFigure create a new VirtualPlaceFigure.
     */
    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        Figure fTarget = drawing().findFigure(x, y);
        if (fTarget instanceof PlaceFigure semanticPlaceFigure) {

            // take the original place as semantic place figure if fTarget is a VirtualPlaceFigure     
            while (semanticPlaceFigure instanceof VirtualPlaceFigure virtualPlaceFigure) {
                semanticPlaceFigure = virtualPlaceFigure.getSemanticFigure();
            }

            virtualPlace = new VirtualPlaceFigure(semanticPlaceFigure);
            view().add(virtualPlace);

            FigureEnumeration children = ((PlaceFigure) fTarget).children();
            Rectangle r = fTarget.displayBox();

            // clone all name inscription from fTarget which may be a VirtualPlaceFigure
            while (children.hasMoreElements()) {
                Figure nextFigure = children.nextFigure();
                if (nextFigure instanceof CPNTextFigure textFig
                    && textFig.getType() == CPNTextFigure.NAME) {

                    CPNTextFigure virtualPlaceName = new CPNTextFigure(CPNTextFigure.NAME);
                    virtualPlaceName.setText(textFig.getText());
                    view().add(virtualPlaceName);
                    virtualPlaceName.setParent(virtualPlace);
                    // calculate text offset
                    int xDistance = textFig.displayBox().x - r.x;
                    int yDistance = textFig.displayBox().y - r.y;

                    virtualPlaceName.moveBy(xDistance, yDistance);
                }
            }
            virtualPlace.displayBox(new Rectangle(r.x, r.y, r.width, r.height));
            changesMade();
        }
    }

    /**
     * Adjust the created connection or split segment.
     */
    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        if (virtualPlace != null) {
            Rectangle r = virtualPlace.displayBox();
            virtualPlace.displayBox(
                new Rectangle(x - (r.width / 2), y - (r.height / 2), r.width, r.height));
        }
    }

    /**
     * Drop new VirtualPlaceFigure.
     */
    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        virtualPlace = null;
        editor().toolDone();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        virtualPlace = null;
    }
}