package de.renew.gui.pnml.parser;

import org.w3c.dom.Element;

import de.renew.gui.pnml.converter.NetConverter;


/**
 * parse all PNML Elements (PetriNets, Objects, Labels)
 */
public abstract class ElementParser {
    private final Element _element;
    private NetConverter _netConverter;

    public ElementParser(Element element, NetConverter converter) {
        _element = element;
        _netConverter = converter;
    }

    Element getElement() {
        return _element;
    }

    NetConverter getNetConverter() {
        return _netConverter;
    }

    void setNetConverter(NetConverter converter) {
        _netConverter = converter;
    }

    /**
     * Parse a PNML Element; use Template Pattern
     */
    public void parse() {
        doParse();
    }

    protected abstract void doParse();
}