package de.renew.gui.pnml.creator;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;

import de.renew.gui.pnml.converter.Converter;


/**
 * Abstract class for creating PNML tags for places, virtual places and transitions
 * that creates the graphics subtag.
 */
public abstract class NodeCreator extends ObjectCreator {
    /**
     * Creates a place
     * @param tag tag of the place
     * @param converter converter of the place
     */
    public NodeCreator(String tag, Converter converter) {
        super(tag, converter);
    }

    @Override
    protected void doCreateGraphic(GraphicCreator creator) {
        Point center = getFigure().center();
        creator.addPosition(center.x, center.y);
        Rectangle dimension = getFigure().displayBox();
        int y = dimension.height;
        int x = dimension.width;
        creator.addDimension(x, y);
        Color c;
        c = (Color) getFigure().getAttribute("FillColor");
        creator.addFill(c);
        c = (Color) getFigure().getAttribute("FrameColor");
        creator.addLineColor(c);
        creator.addLine();
    }
}