package de.renew.formalism.function;

import java.lang.reflect.Field;

import org.junit.jupiter.api.Test;

import de.renew.unify.Impossible;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class FieldFunctionTest {
    public String _testString = "Test String for the Field Object";

    @Test
    public void testFunction() throws NoSuchFieldException, Impossible {
        //given
        Field testField = FieldFunctionTest.class.getField("_testString");
        FieldFunction testFieldFunction = new FieldFunction(testField);
        //when
        Object actualObject = testFieldFunction.function(this);
        //then
        assertTrue(actualObject instanceof Object);
        assertEquals(_testString, actualObject);
    }

    @Test
    public void testFunctionException() throws NoSuchFieldException {
        //given
        Field testField = FieldFunctionTest.class.getField("_testString");
        FieldFunction testFieldFunction = new FieldFunction(testField);
        //when/then
        assertThrows(Impossible.class, () -> {
            testFieldFunction.function("random");
        });
    }
}
