package de.renew.formalism;

import org.junit.jupiter.api.Test;

import de.renew.formalism.bool.SingleBoolNetCompiler;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowPreprocessor;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.mockito.Mockito.mock;


public class SingleBoolNetCompilerTest {
    @Test
    public void testSetShadowLookup() {
        //given
        final SingleBoolNetCompiler testee = new SingleBoolNetCompiler();
        final ShadowLookup lookup = new ShadowLookup();
        //when
        testee.setShadowLookup(lookup);
        //then we dont know how to test

    }

    @Test
    public void testGetRequiredPreprocessors() {
        //given
        final SingleBoolNetCompiler testee = new SingleBoolNetCompiler();
        //when
        final ShadowPreprocessor[] result = testee.getRequiredPreprocessors();
        //then
        assertNotNull(result);
        assertEquals(0, result.length);
    }

    @Test
    public void testCheckDeclarationNode() {
        //given
        final SingleBoolNetCompiler testee = new SingleBoolNetCompiler();
        final ShadowNet shadownet = mock(ShadowNet.class);
        //when
        final String result = testee.checkDeclarationNode("ABC", true, shadownet);
        //then
        assertEquals("unknown", result);
    }

    @Test
    public void testCheckArcInscription() {
        //given
        final SingleBoolNetCompiler testee = new SingleBoolNetCompiler();
        final ShadowNet shadownet = mock(ShadowNet.class);
        //when
        final String result = testee.checkArcInscription("ABC", true, shadownet);
        //then
        assertEquals("unknown", result);
    }

    @Test
    public void testCheckTransitionInscription() {
        //given
        final SingleBoolNetCompiler testee = new SingleBoolNetCompiler();
        final ShadowNet shadownet = mock(ShadowNet.class);
        //when
        final String result = testee.checkTransitionInscription("ABC", true, shadownet);
        //then
        assertEquals("unknown", result);
    }

    @Test
    public void testCheckPlaceInscription() {
        //given
        final SingleBoolNetCompiler testee = new SingleBoolNetCompiler();
        final ShadowNet shadownet = mock(ShadowNet.class);
        //when
        final String result = testee.checkPlaceInscription("ABC", true, shadownet);
        //then
        assertEquals("unknown", result);
    }

}