package de.renew.formalism;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

import de.renew.shadow.ShadowCompilerFactory;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.mockito.Mockito.mock;

@ExtendWith(MockitoExtension.class)
public class CompilerStoreTest {

    @Test
    public void testAddCompilerFactory() {
        // given
        final CompilerStore testee = new CompilerStore();
        final String compilerStoreName = "testCompilerStore";
        final ShadowCompilerFactory factory = mock(ShadowCompilerFactory.class);

        // when
        testee.addCompilerFactory(compilerStoreName, factory);

        // then
        assertFalse(testee.isEmpty());
        assertTrue(testee.containsKey(compilerStoreName));
        assertEquals(factory, testee.get(compilerStoreName));
    }
}
