package de.uni_hamburg.fs;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;


/**
 * A class representing a field feature in Java reflection.
 * Extends JavaFeature to provide field-specific functionality.
 */
class FieldFeature extends JavaFeature {
    /**
     * Logger instance for the FieldFeature class.
     * Used for logging error messages and debugging information.
     */
    public static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(FieldFeature.class);
    private Field _field;

    FieldFeature(Field field) {
        this._field = field;
    }

    @Override
    Class<?> getJavaClass() {
        return _field.getType();
    }

    @Override
    Object getObjectValue(Object javaObject) {
        try {
            return _field.get(javaObject);
        } catch (IllegalAccessException e) {
            // should not happen
            LOGGER.error(e.getMessage(), e);
            throw new RuntimeException("Exception during feature setting:");
        }
    }

    @Override
    boolean canSet() {
        return !Modifier.isFinal(_field.getModifiers());
    }

    @Override
    void setObjectValue(Object javaObject, Object value) {
        try {
            _field.set(javaObject, value);
        } catch (IllegalAccessException e) {
            // should not happen
            LOGGER.error(e.getMessage(), e);
            throw new RuntimeException("Exception during feature setting:");
        }
    }
}