package de.uni_hamburg.fs;

/**
 * Represents a feature in a feature structure, consisting of a name and a type.
 * This class is used to define the characteristics of nodes within the feature structure.
 */
public class Feature {
    /** The name of this feature */
    public final Name _feature;
    /** The type associated with this feature */
    public final Type _type;

    /**
     * Constructs a new Feature with the specified name and type.
     *
     * @param feature the name of the feature
     * @param type the type associated with the feature
     */
    public Feature(Name feature, Type type) {
        this._feature = feature;
        this._type = type;
    }
}