package de.renew.formalism.fsnet;

import java.util.Vector;

import de.renew.shadow.ShadowInscription;
import de.renew.util.StringUtil;

class TransitionRule {
    StringBuffer _fs = new StringBuffer();
    Vector<ShadowInscriptionArea> _inscrAreas = new Vector<ShadowInscriptionArea>();
    int _line = 1;

    void append(String partFS) {
        _fs.append(partFS);
        _line += StringUtil.countLines(partFS) - 1;
    }

    void append(String var, String inscr, ShadowInscription si) {
        _fs.append(SingleXFSNetCompiler.VAR_PREFIX).append(var).append(":\n");
        int startLine = ++_line;
        append(inscr + "\n");
        if (si != null) {
            ShadowInscriptionArea sia = new ShadowInscriptionArea(startLine, _line - 1, si);
            _inscrAreas.addElement(sia);
        }
    }

    @Override
    public String toString() {
        return _fs.toString();
    }
}