package de.renew.formalism.fs;

import java.util.Enumeration;
import java.util.Hashtable;

import de.uni_hamburg.fs.ConceptImpl;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Partition;
import de.uni_hamburg.fs.TypeException;

import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowLookupExtension;
import de.renew.shadow.ShadowLookupExtensionFactory;
import de.renew.shadow.ShadowNetElement;


public class FSShadowLookupExtension implements ShadowLookupExtension {
    public static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(FSShadowLookupExtension.class);

    // the factory producing this kind of extension
    private static final Factory FACTORY = new Factory();

    public static FSShadowLookupExtension lookup(ShadowLookup lookup) {
        return (FSShadowLookupExtension) lookup.getShadowLookupExtension(FACTORY);
    }

    /** Mapping from ShadowConcept to ConceptImpl. */
    private Hashtable<String, ConceptImpl> _conceptMap = new Hashtable<String, ConceptImpl>();

    /** Mapping from ConceptImpl.Feature to ShadowConcept or ShadowAssoc. */
    private Hashtable<String, ShadowNetElement> _appropMap =
        new Hashtable<String, ShadowNetElement>();

    /** Mapping from ConceptImpls to Partition of Subconcepts. */
    private Hashtable<ConceptImpl, Partition> _partitionMap =
        new Hashtable<ConceptImpl, Partition>();

    public void setConcept(ShadowConcept shadowConcept, ConceptImpl concept) {
        _conceptMap.put(shadowConcept.getName(), concept);
    }

    public ConceptImpl getConcept(ShadowConcept shadowConcept) {
        return _conceptMap.get(shadowConcept.getName());
    }

    /*
    public ShadowConcept getShadowConcept(ConceptImpl concept) {
      // use inverse relation:
      Enumeration enum=conceptMap.keys();
      while (enumeration.hasMoreElements()) {
    ShadowConcept key=(ShadowConcept)enumeration.nextElement();
    if (conceptMap.get(key)==concept) {
            return key;
    }
      }
      throw new NoSuchElementException();
    }
    */
    public Enumeration<String> allConcepts() {
        return _conceptMap.keys(); // an enumeration of Concept Namess
    }

    public void setApprop(ConceptImpl concept, Name feature, ShadowNetElement elem) {
        _appropMap.put(concept.getName() + "." + feature, elem);
        //logger.debug("Adding Attribute "+feature+" to concept "+concept.getName());
    }

    public ShadowNetElement getApprop(ConceptImpl concept, Name feature) {
        return _appropMap.get(concept.getName() + "." + feature);
    }

    public void addToSubPartition(ConceptImpl supi, ConceptImpl sub) throws TypeException {
        Partition suppart = _partitionMap.get(supi);
        if (suppart == null) {
            LOGGER.debug("Creating new sub-partition for " + supi.getName());
            LOGGER.debug("Adding " + sub.getName() + " to sub-partition of " + supi.getName());
            suppart = new Partition(sub);
            _partitionMap.put(supi, suppart);
        } else {
            LOGGER.debug("Adding " + sub.getName() + " to sub-partition of " + supi.getName());
            suppart.addConcept(sub);
        }
    }

    public static class Factory implements ShadowLookupExtensionFactory {
        @Override
        public String getCategory() {
            return "de.renew.formalism.fs";
        }

        @Override
        public ShadowLookupExtension createExtension() {
            return new FSShadowLookupExtension();
        }
    }
}