/*
 * Created on Aug 1, 2005
 *
 */

package de.renew.fa.model;

import de.renew.fa.util.FAHelper;


/**
 * Represents a simple implementation for an Arc.
 *
 * @author cabac
 */
public class ArcImpl implements Arc {
    private State _from;
    private Word _inscription;
    private String _name;
    private State _to;

    /**
     * Explicit default constructor.
     */
    public ArcImpl() {
        super();
        // TODO Auto-generated constructor stub
    }

    /**
     * Creates an arc from a state to another state with an inscription. Both states could be the same.
     *
     * @param from from where the arc starts
     * @param inscription what the inscription of the arc
     * @param to where the arc connects to
     */
    public ArcImpl(State from, Word inscription, State to) {
        _name = FAHelper.getArcName(inscription, from, to);
        _from = from;
        _inscription = inscription;
        _to = to;

    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Arc) {
            Arc arc = (Arc) obj;
            if (getFrom().equals(arc.getFrom()) && getTo().equals(arc.getTo())
                && getInscription().equals(arc.getInscription())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public State getFrom() {
        return _from;
    }

    @Override
    public Word getInscription() {
        return _inscription;
    }

    @Override
    public String getName() {
        return _name;
    }

    @Override
    public State getTo() {
        return _to;
    }

    @Override
    public void setInscription(Word inscription) {
        this._inscription = inscription;
    }

    @Override
    public String toString() {
        return _name;
    }

    @Override
    public int hashCode() {
        return getInscription().hashCode() ^ getTo().hashCode() ^ getFrom().hashCode();
    }
}