package de.renew.fa;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.util.Palette;
import de.renew.fa.figures.EndDecoration;
import de.renew.fa.figures.FAArcConnection;
import de.renew.fa.figures.FAFigureCreationTool;
import de.renew.fa.figures.FALoopArcConnectionCreationTool;
import de.renew.fa.figures.FATextFigure;
import de.renew.fa.figures.FAWordTextFigure;
import de.renew.fa.figures.StartDecoration;
import de.renew.fa.figures.StartEndDecoration;
import de.renew.gui.GuiPlugin;
import de.renew.gui.PaletteHolder;


/**
 * This is a creator for <i>one</i> tool {@link Palette} which uses
 * the international style for state representation.
 *
 * <p> For creating the tool with Matthias Jantzen style for
 * tate representation, make use of the {@link PaletteCreator}. </p>
 *
 * <p> The palette uses images taken from {@code /de/renew/fa/images/}
 * </p>
 * {@link CH.ifa.draw.util.Palette}
 * {@link  de.renew.fa.PaletteCreator}
 * @author Lawrence Cabac
 * @version 0.2b, October 2003
 *
 */
public class AltPaletteCreator extends PaletteCreator {

    /**
     * Creates a new AltPaletteCreator.
     *
     * @param name Palette name
     *
    */
    public AltPaletteCreator(String name) {
        super(name);
    }

    @Override
    protected void createPalette(String paletteName) {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (starter == null) {
            LOGGER.error("No GuiPlugin available");
            return;
        }

        // setup palette for adding tools
        String faImageDirectory = "de/renew/fa/images/";
        String guiImageDirectory = "de/renew/gui/images/";
        Tool tool;
        PaletteHolder paletteHolder = starter.getPaletteHolder();
        _palette = new Palette(paletteName);
        DrawingEditor editor = starter.getDrawingEditor();


        // add state tools
        tool = new FAFigureCreationTool(editor, new StartDecoration());
        _palette.add(
            paletteHolder.createToolButton(
                faImageDirectory + "fa_state_s_alt", "FA Start State Tool", tool));

        tool = new FAFigureCreationTool(editor);
        _palette.add(
            paletteHolder.createToolButton(faImageDirectory + "fa_state", "FA State Tool", tool));

        tool = new FAFigureCreationTool(editor, new EndDecoration());
        _palette.add(
            paletteHolder
                .createToolButton(faImageDirectory + "fa_state_e_alt", "FA End State Tool", tool));

        tool = new FAFigureCreationTool(editor, new StartEndDecoration());
        _palette.add(
            paletteHolder.createToolButton(
                faImageDirectory + "fa_state_se_alt", "FA Start End State Tool", tool));


        // add text tools
        FATextFigure prototype = FATextFigure.NAME;
        prototype.setAlignment(TextFigure.CENTER);
        tool = new ConnectedTextTool(editor, prototype);
        _palette
            .add(paletteHolder.createToolButton(guiImageDirectory + "NAME", "FA Name Tool", tool));

        prototype = FATextFigure.INSCRIPTION;
        prototype.setAlignment(TextFigure.CENTER);
        tool = new ConnectedTextTool(editor, prototype);
        _palette.add(
            paletteHolder
                .createToolButton(guiImageDirectory + "INSCR", "FA Inscription Tool", tool));

        FAWordTextFigure word = new FAWordTextFigure();
        word.setAlignment(TextFigure.CENTER);
        tool = new ConnectedTextTool(editor, word);
        _palette.add(
            paletteHolder.createToolButton(
                "de/renew/fa/images/" + "fa_word", "FA Word Placement Tool", tool));

        // add arc tools
        FAArcConnection arc =
            new FAArcConnection(null, new ArrowTip(), AttributeFigure.LINE_STYLE_NORMAL);
        Object spline = Integer.valueOf(PolyLineFigure.BSPLINE_SHAPE);
        arc.setAttribute("LineShape", spline);
        tool = new ConnectionTool(editor, arc);
        _palette.add(
            paletteHolder
                .createToolButton(guiImageDirectory + "ARC", "FA ArcConnection Tool", tool));

        tool = new FALoopArcConnectionCreationTool(editor);
        _palette.add(
            paletteHolder.createToolButton(
                faImageDirectory + "fa_loop", "FA Loop ArcConnection Tool", tool));


        paletteHolder.addPalette(_palette);

    }
}