package de.renew.export.io.exportFormats;

import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.File;

import org.junit.jupiter.api.Test;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.standard.StandardDrawing;

import static org.junit.Assert.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertTrue;

class PDFExportFormatTest {

    @Test
    void testExport() {

        //given
        Drawing drawing = new StandardDrawing();
        Drawing[] drawings = new Drawing[3];
        drawings[0] = drawing;
        File file = new File("test.pdf");
        EPSExportFormat format = new EPSExportFormat();

        //when/then
        try {
            assertEquals(format.export(drawing, file), file);
            assertNotEquals(format.export(drawing, file), null);
            assertNotNull(format.export(drawing, file));
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }

    }

    @Test
    void testInternalExport() {

        //given
        Drawing drawing = new StandardDrawing();
        File file = new File("test.pdf");
        Rectangle rect = new Rectangle(430, 406);
        Rectangle rectSmall = new Rectangle(50, 50);
        PDFExportFormat format = new PDFExportFormat();
        boolean removeWhiteSpace = false;

        //when/then
        try {
            assertEquals(format.internalExport(drawing, file, rect), file);
            assertEquals(format.internalExport(drawing, file, rectSmall), file);
        } catch (Exception e) {
            System.err.println(e.getMessage() + "--");
        }
        try {
            format.internalExport(null, file, null);
        } catch (Exception e) {
            assertEquals(e.getMessage(), "Cannot read field \"x\" because \"bounds\" is null");
        }


    }

    @Test
    void testInternalExportDifferentBounds() {
        //given
        Drawing drawing = new StandardDrawing();
        File file = new File("test.pdf");
        EPSExportFormat format = new EPSExportFormat();
        Rectangle testBounds = new Rectangle(10, 10, 200, 200); // Different bounds
        boolean removeWhiteSpace = true;
        //when/then
        try {
            File result = format.internalExport(drawing, file, testBounds, removeWhiteSpace);
            assertNotNull(result);
            assertTrue(result.exists());
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    @Test
    public void testGetModifier() {
        String headless = System.getProperty("java.awt.headless");
        System.setProperty("java.awt.headless", "false");

        PDFExportFormat format = new PDFExportFormat();
        assertEquals(KeyEvent.SHIFT_DOWN_MASK | KeyEvent.CTRL_DOWN_MASK, format.getModifier());

        // Set Property to its starting value
        if (headless != null) {
            System.setProperty("java.awt.headless", headless);
        } else {
            System.clearProperty("java.awt.headless");
        }

    }
}