package de.renew.export.io.exportFormats;

import java.awt.Rectangle;
import java.io.File;

import org.junit.jupiter.api.Test;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.standard.StandardDrawing;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertTrue;

class EPSExportFormatTest {


    @Test
    void testExport() {
        // given
        Drawing drawing = new StandardDrawing();
        Drawing[] drawings = new Drawing[3];
        drawings[0] = drawing;
        File file = new File("test.eps");
        EPSExportFormat format = new EPSExportFormat();

        //when/then
        try {
            assertEquals(format.export(drawing, file), file);
            assertNotEquals(format.export(drawing, file), null);
            assertNotNull(format.export(drawing, file));
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }


    }

    @Test
    void testInternalExport() {
        //given
        Drawing drawing = new StandardDrawing();
        File file = new File("test.eps");
        Rectangle rect = new Rectangle(430, 406);
        Rectangle rectSmall = new Rectangle(50, 50);
        EPSExportFormat format = new EPSExportFormat();
        boolean removeWhiteSpace = false;

        //when/then
        try {
            assertEquals(format.internalExport(drawing, file, rect, removeWhiteSpace), file);
            assertEquals(format.internalExport(drawing, file, rectSmall, removeWhiteSpace), file);
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
        try {
            format.internalExport(null, file, null, removeWhiteSpace);
        } catch (Exception e) {
            assertEquals(e.getMessage(), "Cannot read field \"x\" because \"bounds\" is null");
        }
    }

    @Test
    void testInternalExportWithoutWhiteSpace() {
        //given
        Drawing drawing = new StandardDrawing();
        File file = new File("test.eps");
        Rectangle rect = new Rectangle(430, 406);
        Rectangle rectSmall = new Rectangle(50, 50);
        EPSExportFormat format = new EPSExportFormat();
        boolean removeWhiteSpace = false;
        //when/then
        try {
            format.internalExport(drawing, file, rect, removeWhiteSpace);
            assertNotNull(file);
            assertTrue(file.exists());
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    @Test
    void testInternalExportWithWhiteSpace() {
        //given
        Drawing drawing = new StandardDrawing();
        File file = new File("test.eps");
        Rectangle rect = new Rectangle(430, 406);
        Rectangle rectSmall = new Rectangle(50, 50);
        EPSExportFormat format = new EPSExportFormat();
        boolean removeWhiteSpace = true;
        //when/then
        try {
            format.internalExport(drawing, file, rect, removeWhiteSpace);
            assertNotNull(file);
            assertTrue(file.exists());
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    @Test
    void testInternalExportDifferentBounds() {
        //given
        Drawing drawing = new StandardDrawing();
        File file = new File("test.eps");
        EPSExportFormat format = new EPSExportFormat();
        Rectangle testBounds = new Rectangle(10, 10, 200, 200); // Different bounds
        boolean removeWhiteSpace = true;
        //when/then
        try {
            File result = format.internalExport(drawing, file, testBounds, removeWhiteSpace);
            assertNotNull(result);
            assertTrue(result.exists());
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}