/*
 * @(#)Storable.java 5.1
 *
 */
package CH.ifa.draw.util;

import java.io.IOException;


/**
 * Interface that is used by StorableInput and StorableOutput
 * to flatten and resurrect objects. Objects that implement
 * this interface and that are resurrected by StorableInput
 * have to provide a default constructor with no arguments.
 * <br>
 * {@link StorableInput}
 * {@link StorableOutput}
 */
public interface Storable {

    /**
     * Stores this object's data in the Output
     * @param dw the output channel
     */
    public void write(StorableOutput dw);

    /**
     * Reads the stored object's data from the Input
     * and saves it as this object's data
     * @param dr the input channel
     * @throws IOException thrown if an I/O error occured
     */
    public void read(StorableInput dr) throws IOException;
}