package CH.ifa.draw.util;

import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;

import CH.ifa.draw.standard.ToolButton;

/**
 * A class that creates a new palette as a new JToolBar.
 * Provides functions to get the created toolbar and add toolButtons to the toolbar.
 */
public class Palette {
    private JToolBar toolBar;
    private List<ToolButton> toolButtons;

    /**
     * Constructs a new palette with the param title as title and as tool tip.
     * The JToolBar won't have any margin and the border of the toolbar's buttons
     * will only be visible on mouse hover.
     *
     * @param title the name of the new palette
     */
    public Palette(String title) {
        toolButtons = new ArrayList<>();
        toolBar = new JToolBar();
        toolBar.setName(title);
        toolBar.setToolTipText(title);
        // toolBar.setBackground(Color.lightGray);
        // toolBar.setLayout(new PaletteLayout(2, new Point(2, 2), false));
        toolBar.setRollover(true);
        toolBar.setMargin(new Insets(0, 0, 0, 0));
    }

    /**
     * Returns the toolbar of this palette.
     * <br>
     * This method also checks if the ToolButtons that were added to this palette are still included in the toolbar.
     * If the buttons are missing they are readded.
     *
     * @return {@link JToolBar} The toolbar.
     */
    public Component getComponent() {
        Component[] components = toolBar.getComponents();
        for (ToolButton toolButton : toolButtons) {
            AbstractButton button = toolButton.button();
            if (!Arrays.asList(components).contains(button)) {
                toolBar.add(button);
            }
        }
        return toolBar;
    }

    /**
     * Adds a ToolButton the palette.
     *
     * @param c the ToolButton that will be added to the palette
     * @return the JToggleButton of the ToolButton
     */
    public Component add(ToolButton c) {
        toolButtons.add(c);
        toolBar.add(c.button());
        return c.button();
    }
}