package CH.ifa.draw.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

/**
 * This Class contains a Map where all known plugins are stored in.
 * Its initialized with 4 base plugins and provides functionality to guess other plugins by class.
 */
public class KnownPlugins {
    private static final Map<String, String> knownPlugins = new HashMap<String, String>();

    static {
        knownPlugins.put("de.renew.gui.CPNDrawing", "Renew Gui Plugin");
        knownPlugins.put("de.renew.diagram.drawing.DiagramDrawing", "Renew Diagram Plugin");
        knownPlugins.put("de.renew.agent.arm.diagram.ARMDrawing", "Mulan ARM Plugin");
        knownPlugins
            .put("de.renew.agent.modeller.diagram.view.MASDiagramDrawing", "Mulan KBE Plugin");
    }

    /**
     * Get plugin associated with a class.
     * Based on the given classname this function tries to return the equivalent plugin name.
     *
     * @param className name as String of the class, which will be looked up
     * @return name as String of the found plugin or else <code>null</code>
     */
    public static String guessPluginByClass(String className) {
        for (Entry<String, String> entry : knownPlugins.entrySet()) {
            if (entry.getKey().equals(className)) {
                return entry.getValue();
            }
        }
        return null;
    }
}