/**
 *
 */
package CH.ifa.draw.util;

import java.io.*;

import CH.ifa.draw.framework.Drawing;
import de.renew.util.ObjectInputStreamUsingBottomLoader;


/**
 * This class contains utility methods for convenience handling of <code>Drawing</code>.
 *
 * @author cabac
 *
 */
public class DrawingHelper {

    /**
     * Clones the drawing.
     *
     * @param originalDrawing the drawing to be cloned
     * @return a deep clone of the original drawing
     * @throws Exception thrown if cloning of drawing wasn't successful
     */
    public static Drawing cloneDrawing(Drawing originalDrawing) throws Exception {
        Drawing drawing;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(originalDrawing);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStreamUsingBottomLoader(bais);
            Object deserializedObject = ois.readObject();
            drawing = (Drawing) deserializedObject;
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Could not clone drawing: " + originalDrawing.getName(), e);
        }
        return drawing;
    }
}