/*
 * @(#)Command.java 5.1
 *
 */
package CH.ifa.draw.util;


/**
 * Commands encapsulate an action to be executed. Commands have
 * a name and can be used in conjunction with <i>Command enabled</i>
 * ui components.
 * <hr>
 * <b>Design Patterns</b><P>
 * <img src="images/red-ball-small.gif" width=6 height=6 alt=" o ">
 * <b><a href=../pattlets/sld010.htm>Command</a></b><br>
 * Command is a simple instance of the command pattern without undo
 * support.
 * <hr>
 *
 * {@link CommandMenu}
 * {@link CommandMenuItem}
 */
public abstract class Command {
    /**
     * The name of the command.
     */
    protected String fName;
    /**
     * The state if the command is executable.
     */
    protected boolean fExecutable = true;

    /**
     * Constructs a command with the given name.
     * @param name the name of the command.
     */
    public Command(String name) {
        fName = name;
    }

    /**
     * Executes the command.
     */
    public abstract void execute();

    /**
     * Tests if the command can be executed.
     * @return the state if the command is executable.
     */
    public boolean isExecutable() {
        return fExecutable;
    }

    /**
     * Set if the command can be executed.
     * @param executable set the command executable to true/false.
     */
    public void setIsExecutable(boolean executable) {
        fExecutable = executable;
    }

    /**
     * Gets the command name.
     * @return the name of the command.
     */
    public String name() {
        return fName;
    }

    /**
     * Gets possible arguments for this command.
     * <br>
     * {@link de.renew.plugin.command.CLCommand#getArguments()}
     * @return null.
     */
    public String getArguments() {
        return null;
    }
}