/*
 * @(#)DrawingEditor.java 5.1
 *
 */
package CH.ifa.draw.standard;

import java.awt.*;
import java.awt.event.KeyEvent;

import CH.ifa.draw.application.DrawingViewContainer;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.*;


public class NullDrawingEditor implements DrawingEditor {
    public static NullDrawingEditor INSTANCE = new NullDrawingEditor();

    private NullDrawingEditor() {}

    @Override
    public DrawingView view() {
        return NullDrawingView.INSTANCE;
    }

    @Override
    public DrawingView previousView() {
        return NullDrawingView.INSTANCE;
    }

    @Override
    public Drawing drawing() {
        return NullDrawing.INSTANCE;
    }

    @Override
    public Tool tool() {
        return NullTool.INSTANCE;
    }

    @Override
    public Tool defaultTool() {
        return null;
    }

    @Override
    public void setStickyTools(boolean sticky) {}

    @Override
    public boolean isStickyTools() {
        return false;
    }

    @Override
    public void dispatchEvent(KeyEvent evt) {}

    @Override
    public Image getIconImage() {
        return null;
    }

    @Override
    public void toolDone() {}

    @Override
    public void selectionChanged(DrawingView view) {}

    @Override
    public void menuStateChanged() {}

    @Override
    public void showStatus(String string) {}

    @Override
    public void drawingViewContainerActivated(DrawingViewContainer viewContainer) {}

    @Override
    public void drawingViewContainerClosing(DrawingViewContainer viewContainer) {}

    @Override
    public void prepareUndoSnapshot() {}

    @Override
    public void commitUndoSnapshot() {}

    @Override
    public void prepareAccumulatedUndoSnapshot() {}

    @Override
    public void triggerAccumulatedUndoSnapshot() {}

    @Override
    public UndoRedoManager getUndoRedoManager() {
        return null;
    }

    @Override
    public void setCurrentDrawing(DrawingViewContainer dvc) {}

    @Override
    public void doTextEdit(TextFigure textfigure) {

    }

    @Override
    public Toolbar getToolbar() {
        return NullToolbar.INSTANCE;
    }

    @Override
    public void registerDrawingViewFactoryID(Class key, String id) {

    }
}