/*
 * @(#)ParentFigure.java 5.1
 *
 */

package CH.ifa.draw.framework;

/**
 * This interface provides methods to access, add, and remove child figures of ParentFigures.
 */
public interface ParentFigure extends FigureWithDependencies {
    /**
     * Returns an enumeration of all child figures contained in this ParentFigure.
     * @return enumeration of contained child figures
     */
    FigureEnumeration children();

    /**
     * Adds a child figure to this ParentFigure.
     * @param child child to be added
     */
    void addChild(ChildFigure child);

    /**
     * Removes a child figure from this ParentFigure.
     * @param child child to be removed
     */
    void removeChild(ChildFigure child);
}