/*
 * @(#)ParentFigure.java 5.1
 *
 */

package CH.ifa.draw.framework;

/**
 * This interface represents a figure that can have a single parent figure.
 * It provides methods to manage the dependency relationship with that parent,
 * including setting or removing the parent figure and responding to changes
 * in the parent.
 */
public interface ChildFigure extends FigureWithDependencies, FigureChangeListener {

    /**
     * Gets the parent Figure or null if top-level figure.
     * @return parent figure
     */
    ParentFigure parent();

    /**
     * Sets a new parent Figure or removes parent if null.
     * Returns whether the setting was performed.
     * @param newParent new Parent to be set
     * @return boolean, {@code true} if setting was performed
     */
    boolean setParent(ParentFigure newParent);

    /**
     * Returns whether the given ParentFigure can become
     * a new parent of this ChildFigure.
     * Should be called by setParent().
     * @param parent parent to be checked
     * @return boolean, {@code true} if able to become newParent
     */
    boolean canBeParent(ParentFigure parent);

    /**
     * Updates location of child.
     */
    void updateLocation();
}