/*
 * @(#)LineDecoration.java 5.1
 *
 */
package CH.ifa.draw.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;

import CH.ifa.draw.util.Storable;

/**
 * Decorate the start or end point of a line or poly line figure.
 * LineDecoration is the base class for the different line decorations.
 * <p>
 * {@link PolyLineFigure}
 */
public interface LineDecoration extends Storable, Cloneable, Serializable {

    /**
     * Draws the decoration in the direction specified by the two points.
     *
     * @param g graphics used for drawing
     * @param x1 x-coordinates for the starting point (x1, y1)
     * @param y1 y-coordinates for the starting point (x1, y1)
     * @param x2 x-coordinates for the ending point (x2, y2)
     * @param y2 y-coordinates for the ending point (x2, y2)
     * @param fillColor color used to fill the shape
     * @param lineColor color used to outline the shape
     */
    public abstract void draw(
        Graphics g, int x1, int y1, int x2, int y2, Color fillColor, Color lineColor);
}