/*
 * @(#)ElbowTextLocator.java 5.1
 *
 */
package CH.ifa.draw.figures;

import java.awt.Point;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractLocator;

/**
 * A locator that allows locating a point 10 pixels above the center of a Figure.
 */
public class ElbowTextLocator extends AbstractLocator {

    /**
     * Creates a new ElbowTextLocator.
     */
    public ElbowTextLocator() {
        super();
    }

    @Override
    public Point locate(Figure owner) {
        Point p = owner.center();
        return new Point(p.x, p.y - 10); // hack
    }
}